//+------------------------------------------------------------------+
//| RMI.mq4 |
//| Copyright  2006,|
//| http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, "
#property link "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue
#property indicator_level1 15
#property indicator_level2 85
//---- input parameters
extern int RMIPeriod=5;
extern int Shift=5;
//---- buffers
double RMIBuffer[];
double PosBuffer[];
double NegBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
string short_name;
//---- 2 additional buffers are used for counting.
IndicatorBuffers(3);
SetIndexBuffer(1,PosBuffer);
SetIndexBuffer(2,NegBuffer);
//---- indicator line
SetIndexStyle(0,DRAW_LINE);
SetIndexBuffer(0,RMIBuffer);
//---- name for DataWindow and indicator subwindow label
short_name="RMI("+RMIPeriod+")";
IndicatorShortName(short_name);
SetIndexLabel(0,short_name);
//----
SetIndexDrawBegin(0,RMIPeriod);
//----
return(0);
}
//+------------------------------------------------------------------+
//| RMI - Relative Momentum Index |
//+------------------------------------------------------------------+
int start()
{
int i,counted_bars=IndicatorCounted();
double rel,negative,positive;
//----
if(Bars<=RMIPeriod) return(0);
//---- initial zero
if(counted_bars<1)
for(i=1;i<=RMIPeriod;i++) RMIBuffer[Bars-i]=0.0;
//----
i=Bars-RMIPeriod-1;
if(counted_bars>=RMIPeriod) i=Bars-counted_bars-1;
while(i>=0)
{
double sumn=0.0,sump=0.0;
if(i==Bars-RMIPeriod-1)
{
int k=Bars-2;
//---- initial accumulation
while(k>=i)
{
rel=Close[k]-Close[k+Shift];
if(rel>0) sump+=rel;
else sumn-=rel;
k--;
}
positive=sump/RMIPeriod;
negative=sumn/RMIPeriod;
}
else
{
//---- simple moving average
rel=Close[i]-Close[i+Shift];
if(rel>0) sump=rel;
else sumn=-rel;
positive=(PosBuffer[i+1]*(RMIPeriod-1)+sump)/RMIPeriod;
negative=(NegBuffer[i+1]*(RMIPeriod-1)+sumn)/RMIPeriod;
}
PosBuffer[i]=positive;
NegBuffer[i]=negative;
if(negative==0.0) RMIBuffer[i]=0.0;
else RMIBuffer[i]=100.0*positive/(positive+negative);
i--;
}
//----
return(0);
}
//+------------------------------------------------------------------+